<?php

namespace Velis\Mvc\View\Engine;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
interface EngineInterface
{
    /**
     * Return all template variables
     *
     * @param string|null $varName
     * @return array
     */
    public function getVars($varName = null);

    /**
     * Set directory where templates are stored
     *
     * @param string $templateDir
     * @return EngineInterface
     */
    public function setTemplateDir($templateDir): EngineInterface;

    /**
     * Register namespaced static class
     *
     * @param string $class
     * @param string $alias
     * @return EngineInterface
     */
    public function register($class, $alias): EngineInterface;

    /**
     * Assign variables to the template
     *
     * Allows setting a specific key to the specified value, OR passing
     * an array of key => value pairs to set en masse.
     *
     * @param string|array $spec The assignment strategy to use (key or
     * array of key => value pairs)
     * @param mixed $value (Optional) If assigning a named variable,
     * use this as the value.
     * @return void
     */
    public function assign($spec, $value = null): void;

    /**
     * Fetch rendered template
     *
     * @param string $name
     * @return string
     */
    public function fetch($name);
}
