<?php

namespace Velis\Mvc\View\Engine;

use Phalcon\Di\FactoryDefault;
use Velis\Mvc\View;

/**
 * Factory for templating engines
 *
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class EngineFactory
{
    /**
     * @var FactoryDefault
     */
    private $di;

    /**
     * Constructor
     * @param FactoryDefault $di
     */
    public function __construct(FactoryDefault $di)
    {
        $this->di = $di;
    }

    /**
     * Create templating engine instance
     * @param View $view
     * @return EngineInterface
     */
    public function createEngine(View $view): EngineInterface
    {
        return new SmartyEngine($view, $this->di);
    }
}
