<?php

namespace Velis\Mvc\Validators\Rules;

use Velis\App;
use Velis\Filter\Validation;
use Velis\Mvc\Validators\Rules\RuleInterface;

class StringMin implements RuleInterface
{
    private int $min;
    private bool $included;

    public function __construct($min, $included = false)
    {
        $this->min = $min;
        $this->included = $included;
    }

    public function validate(array $data, $fieldName): bool
    {
        /** @var Validation $validation */
        $validation = App::$di->get('validation');
        $validation->add($fieldName, Validation::TYPE_STRING_MIN, [
            "min"      => $this->min,
            "included" => $this->included
        ]);

        return $validation->validate($data)->count() === 0;
    }

    public function getErrorMessage($fieldName): string
    {
        return "{$fieldName} minimum length is {$this->min}";
    }
}
