<?php

namespace Velis\Mvc\Validators\Rules;

class AllowedValues implements RuleInterface
{
    private array $allowedValues;

    public function __construct($allowedValues)
    {
        $this->allowedValues = $allowedValues;
    }

    public function validate(array $data, string $fieldName): bool
    {
        return !array_key_exists($fieldName, $data) || in_array($data[$fieldName], $this->allowedValues);
    }

    public function getErrorMessage($fieldName): string
    {
        return "The {$fieldName} must be one of: " . implode(', ', $this->allowedValues);
    }
}
