<?php

namespace Velis\Mvc\Validators;

use Velis\Output;

class FormValidatorFactory
{
    /**
     * @var string
     */
    protected $module;

    /**
     * @var string
     */
    protected $controller;

    /**
     * @var string
     */
    protected $action;

    public function __construct(string $action, string $controller, string $module)
    {
        $this->module = ucfirst($module);
        $this->controller = Output::toPascalCase($controller);

        $actionParts = explode('-', $action);

        $this->action = implode('', array_map(function ($actionPart) {
            return ucfirst($actionPart);
        }, $actionParts));
    }

    public function getValidator(): FormValidator
    {
        $class = "$this->module\Validators\\{$this->controller}\\{$this->action}Action";
        if (class_exists($class)) {
            return new $class();
        }
        return new NoopFormValidator();
    }
}
