<?php

namespace Velis\Mvc\Dto\Core;

use Spatie\DataTransferObject\DataTransferObject;

class MultiMessageGroup extends DataTransferObject
{
    /** @var string[] */
    public array $successes = [];

    /** @var string[] */
    public array $warnings = [];

    /** @var string[] */
    public array $errors = [];


    public function addSuccess(string $success, ?string $idPrefix = null): void
    {
        $this->successes[] = $idPrefix ? "#{$idPrefix} - {$success}" : $success;
    }

    public function addWarning(string $warning, ?string $idPrefix = null): void
    {
        $this->warnings[] = $idPrefix ? "#{$idPrefix} - {$warning}" : $warning;
    }

    public function addError(string $error, ?string $idPrefix = null): void
    {
        $this->errors[] = $idPrefix ? "#{$idPrefix} - {$error}" : $error;
    }

    public function hasErrors(): bool
    {
        return !empty($this->errors);
    }
}
