<?php

namespace Velis\Mvc\Dto\Core;

use Spatie\DataTransferObject\DataTransferObject;

class ErrorMessageGroup extends DataTransferObject
{
    /** @var Velis\Mvc\Dto\Core\ErrorMessage[] */
    public array $errors;

    public static function fromArrayOfStrings(array $messages)
    {
        return new self([
            'errors' => array_map(fn ($message) => new ErrorMessage(['message' => $message]), $messages)
        ]);
    }

    public static function fromArrayOfArrays(array $messages)
    {
        return new self([
            'errors' => array_map(fn ($message) => new ErrorMessage($message), $messages)
        ]);
    }
}
