<?php

namespace Velis\Mvc\Controller\Listeners;

use Velis\Mvc\Controller\Listeners\Concrete\AbstractListener;

/**
 * It's only a temporary solution, it will be removed after the front-end update to use one pattern for sort param.
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
class TemporaryConvertSortParamListener extends AbstractListener
{
    public function handle(): void
    {
        $sortBy = $this->requestParams->get('sort_by');
        $sort = $this->requestParams->get('sort');

        if ($sortBy && !$sort) {
            $this->requestParams['sort'] = str_replace(',', '|', $sortBy);
            return;
        }

        if (!$sortBy && $sort) {
            $this->requestParams['sort_by'] = str_replace('|', ',', $sort);
        }
    }
}
