<?php

namespace Velis\Mvc\Controller\Listeners;

use Application\Application;
use Velis\App;
use Velis\Log\Sentry\ScopeConfiguration;
use Velis\Mvc\Controller\Exception\ForbiddenException;
use Velis\Mvc\Controller\Listeners\Concrete\AbstractListener;

class SentryMetadata extends AbstractListener
{
    public function handle(): void
    {
        $this->di->get(ScopeConfiguration::class)
            ->setTag('app.module', App::$registry['moduleName'] ?: '-')
            ->setTag('app.controller', App::$registry['controllerName'] ?: '-')
            ->setTag('app.action', App::$registry['actionName'] ?: '-');
    }
}
