<?php

namespace Velis\Mvc\Controller\Listeners;

use Velis\Mvc\Controller\Listeners\Concrete\AbstractListener;
use Velis\Mvc\Controller\Utils\RouteClassifier;

class PrintableActionListener extends AbstractListener
{
    public function handle(): void
    {
        if (!RouteClassifier::isPrintAction($this->dispatcher->getActionName())) {
            return;
        }

        $this->view->enable();
        $this->view->setViewsDir(MODULE_PATH . $this->dispatcher->getModuleName() . '/templates');
        $this->view->setBlank();

        $this->response->setContentType('text/html; charset=utf-8');
    }
}
