<?php

namespace Velis\Mvc\Controller\Listeners;

use Api\RestfulProfiler;
use Velis\App;
use Velis\Mvc\Controller\Listeners\Concrete\AbstractListener;
use Velis\Output;

class InitProfilerListener extends AbstractListener
{
    private function isProfilerAccessible(): bool
    {
        return 1 === (int) ($_REQUEST['profiler'] ?? 0)
            && App::isSuper();
    }

    public function handle(): void
    {
        if ($this->isProfilerAccessible()) {
            $content = Output::jsonDecode($this->response->getContent());
            $content['profiler'] = (new RestfulProfiler())->getProfiler();
            $this->response->setJsonContent($content);
        }
    }
}
