<?php

namespace Velis\Mvc\Controller\Listeners\Concrete;

use Phalcon\Di\Injectable;
use Velis\Filter;

abstract class AbstractListener extends Injectable
{
    protected ?Filter $requestParams;
    protected array $config = [];
    abstract public function handle(): void;

    public function setRequestParams(Filter $params): self
    {
        $this->requestParams = $params;

        return $this;
    }

    public function setConfig(array $config): self
    {
        $this->config = $config;

        return $this;
    }
}
