<?php

namespace Velis\Mvc\Controller\Listeners;

use Api\SyncData;
use Velis\App;
use Velis\Mvc\Controller\Listeners\Concrete\AbstractListener;
use Velis\Output;

class CheckSyncDataListener extends AbstractListener
{
    public function handle(): void
    {
        if (!$this->request->getHeader('check-sync-data')) {
            return;
        }

        $toSync = SyncData::byComplex(App::$user->getBuildingComplexIds());
        $this->response->setHeader('new-sync-data', Output::jsonEncode($toSync));
        $this->response->setHeader('new-app-user-hash', App::$user->getDataHash(true));
    }
}
