<?php

namespace Velis\Mvc\Controller\Listeners;

use Application\Application;
use Velis\App;
use Velis\Mvc\Controller\Exception\ForbiddenException;
use Velis\Mvc\Controller\Listeners\Concrete\AbstractListener;

class ApiAccessListener extends AbstractListener
{
    public function handle(): void
    {
        // Inactive users are assumed to NOT have access to the API.
        $needsActivation = method_exists(Application::class, 'needsActivation')
            ? Application::needsActivation()
            : false;

        // Users who would get redirected in the vintage UI (to TA, demo complex picker etc.) are assumed to NOT have access to the API.
        $shouldRedirect = Application::additionalRedirections(false);

        if ($needsActivation || $shouldRedirect) {
            $targetUrl = App::getBaseUrl();
            $this->response->setHeader('X-SHOULD-REDIRECT-TO', $targetUrl);

            throw new ForbiddenException();
        }
    }
}
