<?php

namespace Velis\Mvc\Controller\Exception;

use Phalcon\Http\Message\ResponseStatusCodeInterface;
use Throwable;
use Velis\Api\HttpExceptionHandler\HttpException;
use Velis\Lang;

final class NotFoundException extends HttpException
{
    public function __construct(
        $message = '',
        $code = 0,
        protected ?string $error = null,
        protected ?array $details = null,
        protected ?int $httpCode = null,
        Throwable $previous = null
    )
    {
        parent::__construct(
            message: $message ?: Lang::get('GENERAL_NOT_FOUND'),
            code: ResponseStatusCodeInterface::STATUS_NOT_FOUND,
            error: null,
            details: null,
            httpCode: ResponseStatusCodeInterface::STATUS_NOT_FOUND,
            previous: $previous
        );
    }
}
