<?php

namespace Velis\Mvc\Controller\Exception;

use Velis\Mvc\Dto\Core\ErrorMessageGroup;

final class FormValidationException extends AbstractHttpException
{
    public const ERROR_TYPE_STRING = 'string';
    public const ERROR_TYPE_ARRAY = 'array';

    protected $code = 400;
    private $errors = [];

    public function __construct(array $errors = [], private string $type = self::ERROR_TYPE_STRING)
    {
        $this->errors = $errors;
        parent::__construct('Form validation failed');
    }

    public function getErrors(): ErrorMessageGroup
    {
        if ($this->type === self::ERROR_TYPE_ARRAY) {
            return ErrorMessageGroup::fromArrayOfArrays($this->errors);
        }

        return ErrorMessageGroup::fromArrayOfStrings($this->errors);
    }

    public static function fromValidationErrors(array $errors): self
    {
        return new self($errors, self::ERROR_TYPE_ARRAY);
    }
}
