<?php

namespace Velis\Mvc;

use Phalcon\Mvc\Controller;

trait AnnotationRoutingTrait
{
    protected Router $router;

    abstract protected function getName(): string;

    private function addAnnotationRoutes(): void
    {
        $controllers = $this->getAnnotatedControllers();

        foreach ($controllers as $controller => $prefix) {
            if (!$prefix || !class_exists($controller)) {
                continue;
            }

            $controllerName = str_ends_with($controller, 'Controller') ? substr($controller, 0, -10) : $controller;

            if (!is_array($prefix)) {
                $prefix = [$prefix];
            }

            foreach ($prefix as $route) {
                $this->router->addModuleResource($this->getName(), $controllerName, $route);
            }
        }
    }

    /**
     * @return array<class-string<Controller>,string|array<string>>
     *
     * Returned array should have the following structure:
     * annotated controller::class => prefix path, e.g.:
     * DemoController::class => '/rest/v{version:[0-9]+}/demo',
     * Array of prefix paths is allowed.
     */
    protected function getAnnotatedControllers(): array
    {
        return [];
    }
}
