<?php

namespace Velis\Mvc;

use Velis\Output;
use Velis\App;

/**
 * Base class for MVC decorators
 * @author Olek Procki <olo@velis.pl>
 */
abstract class AbstractDecorator
{
    const VIEW = 'view';
    const JSON = 'json';


    /**
     * Bind variables to view
     * @return self
     */
    public function bind(): self
    {
        if ($view = App::getService('view')) {
            $view->setVars(
                $this->_getViewData()
            );
        }
        return $this;
    }


    /**
     * Returns data if JSON format
     * @return string
     */
    public function json(): string
    {
        return Output::jsonEncode($this->_getJsonData());
    }


    /**
     * This method should prepare data for MVC view
     * @return array
     */
    abstract protected function _getViewData(): array;


    /**
     * This method should prepare data for JSON output
     * @return array
     */
    abstract protected function _getJsonData(): array;
}
