<?php

namespace Velis\Model\RelationLoader\Relations;

use Velis\Model\DataObject;

/**
 * Many-to-Many database relation logical class.
 *
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 *
 * @template TRelatedModel of DataObject
 * @template TTargetModel of DataObject
 * @extends HasManyOrOneThrough<TRelatedModel, TTargetModel>
 */
class HasManyThroughRelation extends HasManyOrOneThrough
{
    /**
     * @param TRelatedModel $targetModel
     * @param TTargetModel[] $relatedModels
     * @return TRelatedModel[]|null
     */
    public function getRelatedModels(DataObject $targetModel, array $relatedModels): ?array
    {
        // If the Target Model does not have a local key field, return null.
        if (!isset($targetModel[$this->foreignKey])) {
            return null;
        }

        return $relatedModels[$targetModel[$this->foreignKey]];
    }
}
