<?php

namespace Velis\Model;

interface FileInterface
{
    public function getContents(bool $force = false): string;

    public function getFilename(): string;

    public function getSize(): int;

    public function getStoragePath(bool|string|null $thumb = false): string;

    /**
     * Get MIME type
     */
    public function getType(): ?string;

    public function setContents(?string $contents): static;

    /**
     * To be used when file is not being modified and modification attempts may potentially cause issues
     */
    public function disableImageProceeding(): static;
}
