<?php

namespace Velis\Model\File;

use Velis\Model\File;

final class TempFile
{
    /**
     * Temp file resource
     * @var resource
     */
    protected $_tempFile;

    public function __construct(File $file)
    {
        $this->_tempFile = tmpfile();
        fwrite($this->_tempFile, $file->getContents());
    }

    public function getPath(): string
    {
        return stream_get_meta_data($this->_tempFile)['uri'];
    }
}
