<?php

namespace Velis\Model\DataObject;

use Exception;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class NoColumnsException extends Exception
{
    /**
     * @param string $listDatasource
     */
    public function __construct($listDatasource)
    {
        $message = sprintf('No columns found for %s datasource. Make sure the table exists.', $listDatasource);

        parent::__construct($message, 0, null);
    }
}
