<?php

namespace Velis\Microsoft;

class Token
{
    private string $accessToken;
    private int $expiresIn;
    private int $expiresAt;
    private string $tokenType;

    public function __construct(string $accessToken, int $expiresIn, int $expiresAt, string $tokenType)
    {
        $this->accessToken = $accessToken;
        $this->expiresIn = $expiresIn;
        $this->expiresAt = $expiresAt;
        $this->tokenType = $tokenType;
    }

    public function getAccessToken(): string
    {
        return $this->accessToken;
    }


    public function getExpiresIn(): int
    {
        return $this->expiresIn;
    }


    public function isExpired(): bool
    {
        return $this->expiresAt < time();
    }
}
