<?php

namespace Velis\Lang\LangVariant;

use Velis\App\User;
use Velis\Lang\LangVariant;

class LangVariantProvider
{
    private ?LangVariant $buffered = null;

    public function __construct(private readonly User $user)
    {
    }

    public function getLangVariant(): LangVariant
    {
        if (!$this->buffered) {
            $langVariant = $this->user->getLangVariant() ?? '';
            $this->buffered = new LangVariant($langVariant);
        }

        return $this->buffered;
    }
}
