<?php

namespace Velis\Lang;

use Phalcon\Di\DiInterface;
use Phalcon\Di\ServiceProviderInterface;
use Velis\App;
use Velis\Arrays;

class LangServiceProvider implements ServiceProviderInterface
{
    public function register(DiInterface $di): void
    {
        $di->set(LangVariant\LangVariantProvider::class, function () {
            return new LangVariant\LangVariantProvider(App::$user);
        });

        $di->set(LangVariant\OverloadedLangProvider::class, function () use ($di) {
            $langVariantProvider = $di->get(LangVariant\LangVariantProvider::class);
            $overriddenLangs = Arrays::toArray(App::$config->get('langs'));

            return new LangVariant\OverloadedLangProvider($langVariantProvider, $overriddenLangs);
        });
    }
}
