<?php

namespace Velis\Label;

use Velis\Model\DataObject;
use Velis\Model\Cacheable;

/**
 * Object label type model
 * @author Tomasz Frukacz <tomasz.frukacz@velis.pl>
 */
class Type extends DataObject implements Cacheable
{

    /**
     * {@inheritdoc}
     */
    protected static $_sortMode = self::SORT_STRING;

    /**
     * @var string
     */
    protected static $_listDefaultOrder = 'name';


    /**
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.label_type_tab';
    }


    /**
     * Returns label type name
     * @return string
     */
    public function getName()
    {
        return $this->getTranslatedName();
    }
}
