<?php

namespace Velis\Image\Processor\Decorator;

use Velis\Filesystem\FilesystemInterface;

final class SaveAsDecorator extends ImageProcessorDecorator
{
    public function __construct(
        protected FilesystemInterface $filesystem,
        protected readonly string $destKey,
        protected readonly bool $overwrite = true,
    ) {
        parent::__construct($filesystem);
    }

    public function process(string $key): void
    {
        $this->filesystem->write(
            $this->destKey,
            $this->filesystem->read($key),
            $this->overwrite,
        );
    }
}
