<?php

namespace Velis\Image\Processor\Decorator;

use Imagick;
use Velis\Filesystem\FilesystemInterface;

final class ResizeDecorator extends ImageProcessorDecorator
{
    public function __construct(
        protected FilesystemInterface $filesystem,
        protected readonly int $width,
        protected readonly int $height,
    ) {
        parent::__construct($filesystem);
    }

    public function process(string $key): void
    {
        $img = new Imagick();
        $img->readImageBlob($this->filesystem->read($key));
        $img->scaleImage($this->width, $this->height, true);

        $this->filesystem->write($key, $img->getImageBlob());
    }
}
