<?php

namespace Velis\Image\Processor\Decorator;

use Imagick;

final class RemoveExifDecorator extends ImageProcessorDecorator
{
    public function process(string $key): void
    {
        $img = new Imagick();
        $img->readImageBlob($this->filesystem->read($key));

        $exifData = $img->getImageProperties("exif:*");
        if (!empty($exifData)) {
            $img->stripImage();
        }

        $this->filesystem->write($key, $img->getImageBlob());
    }
}
