<?php

namespace Velis\Image\Processor;

use ImageProcessor;

final readonly class BulkProcessor
{
    /**
     * @param array<ImageProcessor> $processors
     */
    public function __construct(
        protected array $processors,
    ) {
    }

    public function process(string $key): void
    {
        foreach ($this->processors as $processor) {
            $processor->process($key);
        }
    }
}
