<?php

namespace Velis\Http\Response;

trait ZipResponseTrait
{
    /**
     * Generate excel file
     */
    protected function zipResponse(string $filePath, string $attachmentName)
    {
        $this->response
            ->setFileToSend($filePath, $attachmentName, false)
            ->setContentType('application/zip')
            ->setHeader('Content-Disposition', 'attachment; filename="' . $attachmentName . '"')
            ->setHeader('Content-Length', filesize($filePath))
            ->send();
    }
}
