<?php

namespace Velis\Http\Response;

use Velis\Model\File\MimeType;
use Velis\Xls;

trait XlsResponseTrait
{
    /**
     * Generate excel file
     */
    private function xlsResponse(string $filename, string $content): void
    {
        if (!str_ends_with($filename, '.xls') && !str_ends_with($filename, '.xlsx')) {
            $filename .= '.' . Xls::FORMAT_XLS;
        }

        $this->response
            ->setContentType(MimeType::APPLICATION_EXCEL)
            ->setHeader('Content-Disposition', "attachment; filename=$filename")
            ->setHeader('Content-Transfer-Encoding', 'binary')
            ->setContent($content)
            ->send();
    }

    /**
     * Generate excel file
     */
    private function xlsxResponse(string $filename, string $content): void
    {
        if (!str_ends_with($filename, '.xlsx')) {
            $filename .= '.xlsx';
        }

        $this->response
            ->setContentType(MimeType::APPLICATION_OPENXML_EXCEL)
            ->setHeader('Content-Disposition', "attachment; filename=$filename")
            ->setHeader('Content-Transfer-Encoding', 'binary')
            ->setContent($content)
            ->send();
    }
}
