<?php

namespace Velis\Http;

use Psr\Http\Message\ResponseInterface;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
interface ClientInterface
{
    /**
     * @param array<string,mixed> $options
     */
    public function request(string $method, string $uri = '', array $options = []): ResponseInterface;

    /**
     * @param array<string,mixed> $options
     */
    public function get(string $uri = '', array $options = []): ResponseInterface;

    /**
     * @param array<string,mixed> $options
     */
    public function post(string $uri = '', array $options = []): ResponseInterface;

    /**
     * @param array<string,mixed> $options
     */
    public function put(string $uri = '', array $options = []): ResponseInterface;
}
