<?php

/**
 * Local hooks manager class
 * @author Michał Nosek <michal.nosek@velis.pl>
 */
class Hooks
{
    private $_commitMsg;
    private $_branch;

    public function getCommitMsg($msgFile)
    {
        if (!$this->_commitMsg) {
            $file = fopen($msgFile, "r");
            $this->_commitMsg  = fgets($file);
            fclose($file);
        }

        return $this->_commitMsg;
    }


    public function getBranch()
    {
        if (!$this->_branch) {
            exec("git branch | grep '*'", $branch);
            $this->_branch = reset($branch);
        }

        return $this->_branch;
    }

    public function checkBranch($branch)
    {
        return strpos($this->_branch, $branch);
    }

    public function checkMsg($msg)
    {
        return strpos($this->_commitMsg, $msg) === 0;
    }
}
