<?php

namespace PHP_CodeSniffer\Standards\SinguStandard\Sniffs\Functions;

use PHP_CodeSniffer\Sniffs\Sniff;
use PHP_CodeSniffer\Files\File;

/**
 *
 * @category  PHP
 * @package   PHP_CodeSniffer
 */
class SinguStandard_Sniffs_Functions_ForbiddenWordsSniff implements Sniff
{
    public $supportedTokenizers = array('JS', 'PHP');
    /**
     * Returns an array of tokens this test wants to listen for.
     *
     * @return array
     */
    public function register()
    {
        return array(
                T_CONSTANT_ENCAPSED_STRING,
                T_DOUBLE_QUOTED_STRING,
               );
    }//end register()


    private $forbbidenNames = array(
        'aaa|bbb|ccc|zzz|xyz',
        'dupa'
    );

    /**
     * Processes this test, when one of its tokens is encountered.
     *
     * @param PHP_CodeSniffer_File $phpcsFile The file being scanned.
     * @param int                  $stackPtr  The position of the current token in the
     *                                        stack passed in $tokens.
     *
     * @return void
     */
    public function process(File $phpcsFile, $stackPtr)
    {

        $tokens = $phpcsFile->getTokens();
        
        foreach ($this->forbbidenNames as $pattern) {
            if (preg_match('/'.$pattern.'/',$tokens[$stackPtr]['content'])) {
                    $error = 'The use of word '. $tokens[$stackPtr]['content'] .' is forbidden';
                    $phpcsFile->addError($error, $stackPtr, 'NotAllowed');
            }
        }


    }//end process()
}//end class

?>
