<?php

namespace Velis\Filter;

use Phalcon\Messages\Messages;

/**
 * @author Jan Małysiak <jan.malysiak@velistech.com>
 */
class Validation
{
    public const TYPE_CALLBACK = 'Callback';
    public const TYPE_DATE = 'Date';
    public const TYPE_DIGIT = 'Digit';
    public const TYPE_EMAIL = 'Email';
    public const TYPE_NUMERICALITY = 'Numericality';
    public const TYPE_PRESENCE_OF = 'PresenceOf';
    public const TYPE_STRING_MAX = 'StringLength\Max';
    public const TYPE_STRING_MIN = 'StringLength\Min';

    /**
     * @var \Phalcon\Validation\ValidationInterface|\Phalcon\Filter\Validation\ValidationInterface
     */
    private $wrapped;

    private ValidatorFactory $validatorFactory;

    /**
     * @param \Phalcon\Validation\ValidationInterface|\Phalcon\Filter\Validation\ValidationInterface $wrapped
     * @param ValidatorFactory $validatorFactory
     */
    public function __construct($wrapped, ValidatorFactory $validatorFactory)
    {
        $this->wrapped = $wrapped;
        $this->validatorFactory = $validatorFactory;
    }

    /**
     * @param array|object $data
     * @return Messages
     */
    public function validate($data): Messages
    {
        return $this->wrapped->validate($data);
    }

    /**
     * @param string|array $field
     * @param string $type
     * @param array $options
     * @return void
     */
    public function add($field, string $type, array $options)
    {
        $validator = $this->validatorFactory->createValidator($type, $options);

        $this->wrapped->add($field, $validator);
    }
}
