<?php

namespace Velis\Filter;


class IpInNetwork
{
    /**
     * Check if IP is in network
     */
    public static function check(string $ip, string $network): bool
    {
        if (strpos($network, '/') === false) {
            $network .= '/32';
        }
        list($network, $mask) = explode('/', $network);
        $ip = ip2long($ip);
        $network = ip2long($network);
        $mask = -1 << (32 - $mask);
        $network &= $mask;
        return ($ip & $mask) == $network;
    }
}
