<?php

namespace Velis\Filesystem\Stream;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
interface StreamInterface
{
    /**
     * @param string $mode
     * @return bool
     */
    public function open($mode = 'r');

    /**
     * @param int $offset
     * @param int $whence
     * @return bool
     */
    public function seek($offset, $whence = SEEK_SET);

    /**
     * @param int $count
     * @return string
     */
    public function read($count);

    /**
     * @return void
     */
    public function close();
}
