<?php

namespace Velis\Filesystem\Stream;

use Gaufrette\Stream;
use Gaufrette\StreamMode;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class GaufretteStreamWrapper implements StreamInterface
{
    /**
     * @var Stream
     */
    private $wrapped;

    /**
     * @param Stream $wrapped
     */
    public function __construct(Stream $wrapped)
    {
        $this->wrapped = $wrapped;
    }

    /**
     * {@inheritDoc}
     */
    public function open($mode = 'r')
    {
        return $this->wrapped->open(new StreamMode($mode));
    }

    /**
     * {@inheritDoc}
     */
    public function seek($offset, $whence = SEEK_SET)
    {
        return $this->wrapped->seek($offset, $whence);
    }

    /**
     * {@inheritDoc}
     */
    public function read($count)
    {
        return $this->wrapped->read($count);
    }

    /**
     * {@inheritDoc}
     */
    public function close()
    {
        $this->wrapped->close();
    }
}
