<?php

namespace Velis\Filesystem;

use InvalidArgumentException;
use Phalcon\Di\Di;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 * @author Szymon Janaczek <szymon.janaczek@singu.com>
 */
class FilesystemFactory
{
    public const TYPE_APP = 'app';
    public const TYPE_UPLOAD = 'upload';

    public function __construct(
        private readonly Di $di,
    ) {
    }

    /**
     * @throws InvalidArgumentException
     */
    public function create(string $type): FilesystemInterface
    {
        return match ($type) {
            self::TYPE_APP => $this->di->get('filesystem.app'),
            self::TYPE_UPLOAD => $this->di->get('filesystem.upload'),
            default => throw new InvalidArgumentException('Nieprawidłowa wartość parametru $type'),
        };
    }

    public function createApp(): FilesystemInterface
    {
        return $this->di->get('filesystem.app');
    }

    public function createUpload(): FilesystemInterface
    {
        return $this->di->get('filesystem.upload');
    }
}
