<?php

namespace Velis\Filesystem\Av\Contract;

use Velis\Filesystem\Av\Concrete\AvScanResult;
use Velis\Filesystem\Av\Exception\OneOrMoreFilesInfectedException;

/**
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
interface AvClientInterface
{
    /**
     * Scan a file or a directory (recursively).
     * A full path is required.
     *
     * Returns whether the given file/directory is clean (true), or not (false).
     */
    public function fileScanInStream(string $filePath): AvScanResult;
}
