<?php

namespace Velis\Filesystem\Av\Concrete;

use RuntimeException;
use Velis\Filesystem\Av\Contract\ConnectionInterface;
use Velis\Filesystem\Av\Contract\SocketInterface;

/**
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
final class Connection implements ConnectionInterface
{
    public function __construct(
        private readonly string $host,
        private readonly int $port,
    ) {
    }

    public function getSocket(): SocketInterface
    {
        $socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
        $status = socket_connect($socket, $this->host, $this->port);

        if (!$status) {
            throw new RuntimeException('Unable to connect to AV server');
        }

        return SocketWrapper::fromSocket($socket);
    }
}
