<?php

namespace Velis\Filesystem\Av\Concrete;

/**
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
final readonly class AvScanResult
{
    public function __construct(
        private bool $isInfected,
    ) {
    }

    public function isInfected(): bool
    {
        return $this->isInfected;
    }

    public static function fromRaw(bool $isInfected): AvScanResult
    {
        return new self(
            isInfected: $isInfected,
        );
    }
}
