<?php

namespace Velis\Exception;

use Throwable;
use Velis\Api\HttpExceptionHandler\HttpException;
use Velis\Lang;

class TokenExpiredException extends HttpException
{
    public function __construct(
        $message = null,
        $code = 0,
        ?string $error = null,
        ?array $details = null,
        ?int $httpCode = null,
        Throwable $previous = null
    ) {
        $message = $message ?: Lang::get('USER_AUTHORIZATION_TOKEN_EXPIRED');
        $httpCode = $httpCode ?: 406;

        parent::__construct($message, $code, $error, $details, $httpCode, $previous);
    }
}
