<?php

namespace Velis\Dto\Validators;

use Attribute;

#[Attribute]
class FormatValidator extends BaseValidator
{
    public function __construct(
        public string $format,
        public string $message = 'Invalid format'
    ) {
    }

    public function validate($value): bool
    {
        return preg_match('/' . $this->format . '/', $value);
    }
}
