<?php

namespace Velis\Debugger\Renderer;

use Throwable;
use Velis\Dto\BaseDto;
use Whoops\Handler\PrettyPageHandler;
use Whoops\Run;

/**
 * Use Whoops to render the exception in HTML - in a pretty way.
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
class WhoopsHtmlRenderer implements RendererInterface
{
    /**
     * @param BaseDto[] $modulesOutput
     */
    public function get(Throwable $throwable, array $modulesOutput = []): string
    {
        $whoops = new Run();
        $whoops->allowQuit(true);
        $whoops->writeToOutput(true);
        $handler = new PrettyPageHandler();

        $modulesOutputArray = array_map(fn (BaseDto $moduleResult) => $moduleResult->toArray(), $modulesOutput);

        $handler->addDataTable('Modules', $modulesOutputArray);
        $whoops->pushHandler($handler);

        return $whoops->handleException($throwable);
    }
}
