<?php

namespace Velis\Debugger\Renderer;

use Throwable;
use Velis\Dto\BaseDto;

/**
 * Interface for the renderer.
 * Renders the output of the debugger.
 * If you need a specific output format, implement this interface and append as a renderer to the Debugger.
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
interface RendererInterface
{
    /**
     * @param BaseDto[] $modulesOutput
     */
    public function get(Throwable $throwable, array $modulesOutput = []): mixed;
}
