<?php

namespace Velis\Db;

use Closure;
use Velis\App;

/**
 * @author Łukasz Gąsiorek <lukasz.gasiorek@velistech.com>
 */
trait WithoutDuplicateQueryCheckTrait
{
    /**
     * @throws Exception
     */
    public function withoutDuplicateQueryCheck(Closure $fn)
    {
        /** @var Db $db */
        $db = App::getService('db');
        $restore = $db->checkDuplicatedQueries(false);

        try {
            return $fn($db);
        } catch (Exception $e) {
            throw $e;
        } finally {
            $db->checkDuplicatedQueries($restore);
        }
    }
}
