<?php

namespace Velis\Db;

/**
 * @author Damian Kurek <damian.kurek@velistech.com>
 */
class SqlScriptParser
{
    /**
     * @param string $sql
     * @param $params
     * @return string
     */
    public function parse(string $sql, $params = []): string
    {
        foreach ($params as $key => $param) {
            $param = str_replace("'", "''", $param);
            if (!is_numeric($param)) {
                $param = "'$param'";
            }
            $sql = str_replace(":$key", $param, $sql);
        }
        return $sql;
    }
}
