<?php

namespace Velis\Db\QueryBuilder;

use Velis\Db\QueryBuilder\Enums\WhereSeparator;

/**
 * @author Jakub Szczugieł <jakub.szczugiel@velistech.com>
 */
class WhereExpression
{
    public function __construct(
        private readonly string $sql,
        private readonly WhereSeparator $separator = WhereSeparator::AND,
    ) {
    }

    public function getSeparator(): string
    {
        return $this->separator->value;
    }

    public function getSql(): string
    {
        return $this->sql;
    }
}
